/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.comm;

import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class TcpSocketDataTransfer
extends DataTransfer {
    Socket fSocket = null;
    public static final int TCP_TIMEOUT = 15;
    public static final int DATALOG_PACKET_SIZE = 500;
    private InetAddress fCurrentAddress;
    private int standardTimeOut = 5001;
    private static boolean fEnableLOGOServer = true;

    public static DataTransfer openConnection(String IPAddress, boolean showError, boolean ignoreDevice) throws ExceptionAlreadyHandledException {
        TcpSocketDataTransfer dt = null;
        try {
            InetAddress destinationIP = InetAddress.getByName(IPAddress);
            dt = new TcpSocketDataTransfer(destinationIP, 10001);
        }
        catch (IOException e) {
            if (showError) {
                Object[] arr = new String[]{IPAddress};
                new LogoError(null, "error.com.noPort", "Can not open the interface.", arr, 0, 0).display();
            }
            throw new ExceptionAlreadyHandledException();
        }
        dt.setShowErrorDialog(showError);
        try {
            if (!ignoreDevice) {
                dt.reConnect();
            }
        }
        catch (Exception e) {
            if (cPort != null) {
                cPort.closePort();
            }
            throw new ExceptionAlreadyHandledException();
        }
        return dt;
    }

    protected TcpSocketDataTransfer(InetAddress destinationIP, int socketNr) throws IOException {
        this.fCurrentAddress = destinationIP;
        this.fSocket = new Socket();
        this.fSocket.connect(new InetSocketAddress(destinationIP, socketNr), 5000);
        this.fSocket.setTcpNoDelay(false);
        this.fSocket.setSoTimeout(15);
        this.fInputStream = this.fSocket.getInputStream();
        this.fOutputStream = this.fSocket.getOutputStream();
        cPort = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePort() {
        if (this.fSocket != null) {
            try {
                if (fEnableLOGOServer) {
                    this.sendTestString("end");
                    Thread.sleep(100L);
                }
                this.fInputStream.close();
                this.fOutputStream.close();
                this.fSocket.close();
                if (this.fDebugGeneral) {
                    System.out.println("fport closed: " + this);
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.fSocket = null;
            }
        }
    }

    private void sendTestString(String str) {
        try {
            PrintWriter out = new PrintWriter(this.fOutputStream);
            out.print(str);
            out.flush();
        }
        catch (Exception e) {
            System.out.println("failed to write.");
        }
    }

    public String toString() {
        return "Socket Port 10001";
    }

    protected void resetInternalWait() {
        this.resetInternal();
    }

    protected int getReadByteRetryTimes() {
        return 3;
    }

    protected int readInputStream(byte[] b) throws IOException {
        try {
            return this.fInputStream.read(b);
        }
        catch (SocketTimeoutException te) {
            return 0;
        }
        catch (IOException e) {
            throw e;
        }
    }

    protected int maxBytesInOneTelegram() {
        return 512;
    }

    protected boolean isCheckPointOfWritingBytes(int index) {
        boolean ret = index > 0 && index % 200 == 0;
        return ret;
    }

    public void rebuildConnection() throws ExceptionAlreadyHandledException {
        try {
            this.closePort();
            this.fSocket = new Socket();
            this.fSocket.connect(new InetSocketAddress(this.fCurrentAddress, 10001), 5000);
            this.fSocket.setTcpNoDelay(false);
            this.fSocket.setSoTimeout(15);
            this.fInputStream = this.fSocket.getInputStream();
            this.fOutputStream = this.fSocket.getOutputStream();
            cPort = this;
        }
        catch (IOException e) {
            Object[] arr = new String[1];
            String address = this.fCurrentAddress.toString();
            arr[0] = address.substring(1, address.length());
            new LogoError(null, "error.com.noPort", "Can not open the interface.", arr, 0, 0).display();
            throw new ExceptionAlreadyHandledException();
        }
        this.setShowErrorDialog(true);
        try {
            this.reConnect();
        }
        catch (Exception e) {
            if (cPort != null) {
                cPort.closePort();
            }
            throw new ExceptionAlreadyHandledException();
        }
    }

    public String getRemoteAddress() {
        return this.fSocket.getInetAddress().getHostAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int uploadDataLogData(File dataLogFile) throws TransmissionFailedException {
        int ret = -1;
        FileOutputStream os = null;
        OutputStreamWriter fFileWriter = null;
        try {
            os = new FileOutputStream(dataLogFile);
            fFileWriter = new OutputStreamWriter(os);
            if (this.sendStateCommand(37)) {
                int dataLogSource;
                ret = dataLogSource = this.readInternalByte();
                if (dataLogSource == 0) {
                    this.writeCommandByte(16640, 0, this.getStandardTimeOut());
                    int n = ret;
                    return n;
                }
                if (dataLogSource == 1) {
                    int n = ret;
                    return n;
                }
                if (dataLogSource == 2) {
                    int packetLength;
                    this.readInternalByte();
                    this.readInternalByte();
                    this.readInternalByte();
                    this.readInternalByte();
                    do {
                        int n;
                        this.writeToOutputStream(6);
                        int startByte = this.readInternalByte();
                        int command1 = this.readInternalByte();
                        int command2 = this.readInternalByte();
                        int status = this.readInternalByte();
                        if (startByte != 85 || command1 != 37 || command2 != 37) {
                            new LogoError(Language.getString("extra.transfer.datalogTelegramErr", "Data log telegram error.")).display();
                            n = -1;
                            return n;
                        }
                        if (status != 0) {
                            new LogoError(Language.getString("extra.transfer.datalogBMErr", "Error occurs on BM.")).display();
                            n = -1;
                            return n;
                        }
                        int packetLengthLow = this.readInternalByte();
                        int packetLengthHign = this.readInternalByte();
                        int calculatedChecksum = 0;
                        packetLength = packetLengthLow | packetLengthHign << 8;
                        char[] logData = new char[500];
                        for (int i = 0; i < packetLength; ++i) {
                            int temp = this.readInternalByte();
                            logData[i] = (char)temp;
                            calculatedChecksum = (short)(calculatedChecksum + temp);
                        }
                        int checsumLow = this.readInternalByte();
                        int checsumHigh = this.readInternalByte();
                        this.readInternalByte();
                        int checksum = checsumLow | checsumHigh << 8;
                        if (checksum != (calculatedChecksum & 0xFFFF)) {
                            new LogoError(Language.getString("extra.transfer.datalogChecksumErr", "Checksum error.")).display();
                            int n2 = -1;
                            return n2;
                        }
                        fFileWriter.write(logData, 0, packetLength);
                        fFileWriter.flush();
                    } while (packetLength == 500);
                    this.writeToOutputStream(6);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fFileWriter.close();
                ((OutputStream)os).close();
            }
            catch (IOException e) {}
            fFileWriter = null;
            os = null;
        }
        return ret;
    }

    public int getStandardTimeOut() {
        return this.standardTimeOut;
    }

    public void setStandardTimeOut(int standardTimeOut) {
        this.standardTimeOut = standardTimeOut;
    }

    public void waitUntilDeviceReady(int maxRetry, int supportedState, boolean showProgressListener) {
        this.setStandardTimeOut(1001);
        super.waitUntilDeviceReady(maxRetry, supportedState, showProgressListener);
        this.setStandardTimeOut(5001);
    }

    public static class LOGOServer {
        public static void main(String[] args) throws IOException {
            ServerSocket server = new ServerSocket(10001);
            byte[] buffer = new byte[8192];
            while (true) {
                Socket client = server.accept();
                client.setSoTimeout(15);
                while (true) {
                    int index = 0;
                    try {
                        int curCount = 0;
                        while (client.getInputStream().available() > 0) {
                            System.out.println("From " + System.currentTimeMillis());
                            curCount = client.getInputStream().read(buffer, index, 1);
                            if (curCount <= 0) continue;
                            index += curCount;
                        }
                        if (index > 0) {
                            System.out.println(" to " + System.currentTimeMillis() + " " + index);
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (index > 0) {
                        if (buffer[index - 2] == 20 && buffer[index - 1] == 106) {
                            for (int i = 0; i < 5226; ++i) {
                                client.getOutputStream().write(0);
                            }
                            client.getOutputStream().write(100);
                        } else {
                            client.getOutputStream().write(21);
                        }
                        client.getOutputStream().flush();
                        StringBuffer str = new StringBuffer();
                        for (int i = 0; i < index; ++i) {
                            String s = Integer.toHexString(buffer[i] & 0xFF).toUpperCase();
                            if (s.length() == 1) {
                                s = "0" + s;
                            }
                            str.append((char)(buffer[i] + 256 & 0xFF));
                        }
                        if (str.toString().contains("end")) break;
                    }
                    try {
                        Thread.sleep(0L);
                    }
                    catch (Exception e) {}
                }
                System.out.println("Recieve end string.");
                client.close();
            }
        }
    }
}

